<?php

namespace App\Helper;

final class PriorityQueue
{
    private array $data = [];

    /**
     * @param iterable<PrioritizableInterface> $data
     */
    public function __construct(iterable $data = [])
    {
        foreach ($data as $prioritizable) {
            $this->addPrioritizable($prioritizable);
        }
    }

    public function addPrioritizable(PrioritizableInterface $prioritizable): void
    {
        $this->add($prioritizable, $prioritizable->getPriority());
    }

    public function add(mixed $entry, int $priority): void
    {
        $this->data[$priority][] = $entry;
    }

    public function getTopEntry(mixed $default = null): PriorityQueueEntry
    {
        if (empty($this->data)) {
            return new PriorityQueueEntry($default, 0);
        }

        $priority = max(array_keys($this->data));
        $entries = $this->data[$priority];
        $lastKey = max(array_keys($entries));

        return new PriorityQueueEntry($entries[$lastKey], $priority);
    }
}