<?php

declare(strict_types=1);

namespace App\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class UppyType extends AbstractType
{
    private const DEFAULT_ATTRIBUTES = [
        'label' => false,
    ];

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'compound' => false,
            'attr' => self::DEFAULT_ATTRIBUTES
        ]);

        $resolver->setNormalizer('attr', static function (Options $options, $attributes): ?array {
            if (null === $attributes) {
                return $attributes;
            }

            if (is_string($attributes)) {
                $attributes = (array)$attributes;
            }

            return array_merge($attributes, self::DEFAULT_ATTRIBUTES);
        });

    }
}
