<?php

declare(strict_types=1);

namespace App\Form\System\Page;

use App\Entity\System\Page\Page;
use App\Form\Abstract\BaseType;
use App\Form\Type\BaseTranslationsType;
use App\Form\Type\EditorJsType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class PageType extends BaseType
{

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        parent::buildForm($builder, $options);
        $builder
            ->add('translations', BaseTranslationsType::class, [
                'label' => false,
                'fields' => [
                    'title' => [],
                    'content' => [
                        'field_type' => EditorJsType::class,
                    ]
                ]
            ]);
    }
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Page::class,
            'locale' => ''
        ]);
    }
}
