<?php

declare(strict_types=1);

namespace App\Form\System;

use App\Entity\Common\Address;
use App\Entity\System\Message;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class MessageType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add($builder->create('general', FormType::class, ['inherit_data' => true]));

        $builder->get('general')
            ->add('name')
            ->add('email')
            ->add('message')
            ;


    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Message::class,
            'locale' => ''
        ]);
    }
}
