<?php

declare(strict_types=1);

namespace App\Form\System\Administrator;

use App\Entity\System\Administrator\Administrator;
use App\Enum\Shared\TwoFactorProvider;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\EnumType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class SettingsType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add(
                $builder
                    ->create('general', FormType::class, ['inherit_data' => true])
                    ->add('firstName')
                    ->add('lastName')
                    ->add('email', EmailType::class)
                    ->add('twoFactorProvider', EnumType::class, [
                        'class' => TwoFactorProvider::class,
                        'required' => false
                    ])
            );
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Administrator::class,
            'locale' => ''
        ]);
    }
}
