<?php

declare(strict_types=1);

namespace App\Form\Magazine\Article;

use App\Entity\Magazine\Article\Article;
use App\Entity\System\Administrator\Administrator;
use App\Form\Abstract\BaseType;
use App\Form\Type\BaseTranslationsType;
use App\Form\Type\EditorJsType;
use Arkounay\Bundle\UxMediaBundle\Form\UxMediaType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class ArticleType extends BaseType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        parent::buildForm($builder, $options);

        $builder->add('translations', BaseTranslationsType::class, [
            'label' => false,
            'fields' => [
                'title' => [],
                'intro' => [],
                'publishedAt' => [],
                'content' => [
                    'field_type' => EditorJsType::class,
                ]
            ]
        ])
            ->get('relations')
            ->add('author', EntityType::class, [
                'class' => Administrator::class,
                'choice_label' => 'fullName'
            ])
            ->add('relatedArticles', ArticleAutocompleteField::class, [
                'multiple' => true,
                'required' => false
            ])
            ->add('image', UxMediaType::class,['conf' => 'default']);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Article::class,
            'locale' => ''
        ]);
    }
}
