<?php

declare(strict_types=1);

namespace App\Form\Education;

use App\Entity\Education\Lesson\Lesson;
use App\Form\Abstract\BaseType;
use App\Form\Type\BaseTranslationsType;
use App\Form\Type\EditorJsType;
use Arkounay\Bundle\UxMediaBundle\Form\UxMediaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class LessonType extends BaseType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        parent::buildForm($builder, $options);

        $builder->add('translations', BaseTranslationsType::class, [
            'label' => false,
            'fields' => [
                'title' => [],
                'intro' => [],

                'preview' => [
                    'field_type' => UxMediaType::class,
                    'conf' => 'default'
                ],
                'pdf' => [
                    'field_type' => UxMediaType::class,
                    'conf' => 'default'
                ]
            ],
            'excluded_fields' => ['createdAt', 'updatedAt', 'deletedAt', 'createdBy', 'updatedBy', 'deletedBy', 'slug','content','publishedAt'],
        ])
            ->get('relations')
            ->add('sort')
            ->add('category', CategoryAutocompleteField::class, [
                'required' => true
            ])->remove('tags')
            ->add('image', UxMediaType::class,['conf' => 'default']);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Lesson::class,
            'locale' => ''
        ]);
    }
}
