<?php

declare(strict_types=1);

namespace App\Form\Education;

use App\Entity\Education\Lesson\Category;
use App\Form\Abstract\BaseType;
use App\Form\Type\BaseTranslationsType;
use App\Form\Type\EditorJsType;
use Arkounay\Bundle\UxMediaBundle\Form\UxMediaType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class CategoryType extends BaseType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        parent::buildForm($builder, $options);

        $builder->add('translations', BaseTranslationsType::class, [
            'label' => false,
            'fields' => [
                'title' => [],
                'intro' => [],
            ],
            'excluded_fields' => ['createdAt', 'updatedAt', 'deletedAt', 'createdBy', 'updatedBy', 'deletedBy', 'slug','isHighlighted','content','publishedAt'],
        ])
            ->get('relations')
            ->add('startDate',DateTimeType::class)
            ->add('endDate',DateTimeType::class)
            ->add('isApply',CheckboxType::class)
            ->add('image', UxMediaType::class,['conf' => 'default'])
            ->add('highlightedImage', UxMediaType::class,['conf' => 'default'])
            ->remove('tags')
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Category::class,
            'locale' => ''
        ]);
    }
}
