<?php

declare(strict_types=1);

namespace App\Form\Education;

use App\Entity\Education\Lesson\Category;
use App\Repository\Education\Lesson\CategoryRepository;
use Doctrine\ORM\QueryBuilder;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\UX\Autocomplete\Form\AsEntityAutocompleteField;
use Symfony\UX\Autocomplete\Form\ParentEntityAutocompleteType;

#[AsEntityAutocompleteField]
final class CategoryAutocompleteField extends AbstractType
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'class' => Category::class,
            'choice_label' => static fn($category) => $category->getTitle(),
            'query_builder' => static fn(CategoryRepository $categoryRepository): QueryBuilder => $categoryRepository->createQueryBuilder('category')
        ]);
    }

    public function getParent(): string
    {
        return ParentEntityAutocompleteType::class;
    }
}
