<?php

declare(strict_types=1);

namespace App\Form\Education;

use App\Entity\Education\Apply;
use App\Form\Abstract\BaseType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class ApplyType extends BaseType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        parent::buildForm($builder, $options);
        if (!$builder->has('general')) {
            $builder->add($builder->create('general', FormType::class, ['inherit_data' => true]));
        }
        $builder
            ->get('general')
            ->add('firstName')
            ->add('lastName')
            ->add('email')

        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Apply::class,
            'locale' => ''
        ]);
    }
}
