<?php

declare(strict_types=1);

namespace App\Form\Common;

use App\Entity\Common\Tag\Tag;
use App\Form\Abstract\BaseType;
use App\Form\Type\BaseTranslationsType;
use Arkounay\Bundle\UxMediaBundle\Form\UxMediaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class TagType extends BaseType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        parent::buildForm($builder, $options);

        $builder->add('translations', BaseTranslationsType::class, [
            'label' => false,
            'fields' => [
                'title' => [],
                'image' => [
                    'field_type' => UxMediaType::class,
                    'conf' => 'default'
                ]
            ]
        ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Tag::class,
            'locale' => ''
        ]);
    }
}
