<?php

declare(strict_types=1);

namespace App\Form\Common;

use App\Entity\Common\Meta\Meta;
use App\Form\Type\BaseTranslationsType;
use Arkounay\Bundle\UxMediaBundle\Form\UxMediaType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class MetaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('translations', BaseTranslationsType::class, [
            'label' => false,
            'fields' => [
                'image' => [
                    'field_type' => UxMediaType::class,
                    'conf' => 'default'
                ]
            ]
        ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Meta::class,
        ]);
    }
}
