<?php

declare(strict_types=1);

namespace App\Form\Common;

use App\Entity\Common\Support\Faq;
use App\Form\Abstract\BaseType;
use App\Form\Type\BaseTranslationsType;
use App\Form\Type\EditorJsType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class FaqType extends BaseType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        parent::buildForm($builder, $options);

        $builder->add('translations', BaseTranslationsType::class, [
            'label' => false,
            'fields' => [
                'question' => [],
                'content' => [
                    'field_type' => EditorJsType::class
                ],
            ]
        ]);

        if (!$builder->has('relations')) {
            $builder->add($builder->create('relations', FormType::class, ['inherit_data' => true]));
        }

        $builder->get('relations')
            ->add('topic', TopicAutocompleteField::class, [
            'required' => true
        ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Faq::class,
            'locale' => ''
        ]);
    }
}
