<?php

declare(strict_types=1);

namespace App\Form\Common;

use App\Entity\Common\Address;
use App\Enum\Shared\AddressType as AddressTypeEnum;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CountryType;
use Symfony\Component\Form\Extension\Core\Type\EnumType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class AddressType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add($builder->create('general', FormType::class, ['inherit_data' => true]));
        $builder->add($builder->create('relations', FormType::class, ['inherit_data' => true]));

        $builder->get('general')
            ->add('zip')
            ->add('city')
            ->add('street')
            ->add('streetType')
            ->add('houseNumber')
            ->add('floor')
            ->add('door');

        $builder->get('relations')
            ->add('country', CountryType::class)
            ->add('type', EnumType::class, [
                'class' => AddressTypeEnum::class
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Address::class,
            'locale' => ''
        ]);
    }
}
