<?php

declare(strict_types=1);

namespace App\Factory\User;

use App\DTO\PublicAPI\User\Input\FormRegistration;
use App\Entity\User\User;
use Symfony\Component\PasswordHasher\Hasher\UserPasswordHasherInterface;

final readonly class UserFactory
{
    public function __construct(
        private UserPasswordHasherInterface $userPasswordHasher
    )
    {
    }

    public function createFromRegistration(FormRegistration $formRegistration, string $locale): User
    {

        $user = $this->create($formRegistration->email);
        $user->setFirstName($formRegistration->firstName);
        $user->setLastName($formRegistration->lastName);
        $user->setLocale($locale);
        $user->setPassword(
            $this->userPasswordHasher->hashPassword($user, $formRegistration->password)
        );

        return $user;
    }

    public function create(string $email): User
    {
        $user = new User();
        $user->setEmail($email);
        $user->setRoles([]);

        return $user;
    }
}
