<?php

declare(strict_types=1);

namespace App\Factory\Shared;

use App\DTO\PublicAPI\Address\Input\AddressManage;
use App\Entity\Common\Address;

final class AddressFactory
{
    public function manage(
        AddressManage $addressManage,
        ?Address      $address = null
    ): Address
    {
        $address ??= new Address();
        $address->setType($addressManage->type);
        $address->setCountry($addressManage->country);
        $address->setZip($addressManage->zip);
        $address->setCity($addressManage->city);
        $address->setStreet($addressManage->street);
        $address->setStreetType($addressManage->streetType);
        $address->setHouseNumber($addressManage->houseNumber);
        $address->setBuilding($addressManage->building);
        $address->setDoor($addressManage->door);

        return $address;
    }

}
