<?php

declare(strict_types=1);

namespace App\Exception\View;

use Symfony\Component\HttpKernel\Exception\HttpException;

final class ManualConstraintViolationException extends HttpException
{
    public function __construct(
        private readonly string $path,
        private readonly string $violationMessage
    )
    {
        parent::__construct(
            statusCode: 422,
            message: 'Constraint violation',
            code: 422
        );
    }

    public function getPath(): string
    {
        return $this->path;
    }

    public function getViolationMessage(): string
    {
        return $this->violationMessage;
    }
}
