<?php

declare(strict_types=1);

namespace App\Exception\View;

use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\Validator\ConstraintViolationListInterface;

final class ConstraintViolationException extends HttpException
{
    public function __construct(
        private readonly ConstraintViolationListInterface $violations
    )
    {
        parent::__construct(
            statusCode: 422,
            message: 'Constraint violation',
            code: 422
        );
    }

    public function getViolations(): ConstraintViolationListInterface
    {
        return $this->violations;
    }
}
