<?php

namespace App\EventSubscriber\System;

use App\Entity\Common\Layout\Block;
use App\Entity\Interfaces\BlockableInterface;
use Doctrine\Bundle\DoctrineBundle\EventSubscriber\EventSubscriberInterface;
use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use Doctrine\ORM\Events;
use Doctrine\ORM\Mapping\ClassMetadataInfo;
use ReflectionClass;

final class BlockableEventSubscriber implements EventSubscriberInterface
{
    private const BLOCK = 'blocks';

    private const BLOCKABLE_ENTITY = Block::class;

    public function loadClassMetadata(LoadClassMetadataEventArgs $loadClassMetadataEventArgs): void
    {
        $classMetadata = $loadClassMetadataEventArgs->getClassMetadata();

        if (!$classMetadata->reflClass instanceof ReflectionClass) {
            return;
        }

        if (!is_a($classMetadata->reflClass->getName(), BlockableInterface::class, true)) {
            return;
        }

        $this->mapEntity($classMetadata);
    }

    private function mapEntity(ClassMetadataInfo $classMetadataInfo): void
    {
        if (class_exists(self::BLOCKABLE_ENTITY)) {
            $this->mapManyToManyBlock($classMetadataInfo);
        }
    }

    private function mapManyToManyBlock(ClassMetadataInfo $classMetadataInfo): void
    {
        $this->mapManyToManyWithTargetEntity($classMetadataInfo);
    }

    private function mapManyToManyWithTargetEntity(ClassMetadataInfo $classMetadataInfo): void
    {
        if ($classMetadataInfo->hasAssociation(self::BLOCK)) {
            return;
        }

        $tableName = $classMetadataInfo->table['name'];

        $classMetadataInfo->mapManyToMany([
            'fieldName' => self::BLOCK,
            'targetEntity' => self::BLOCKABLE_ENTITY,

            'joinTable' => [
                'name' => $tableName . '_to_block',
            ],
            'cascade' =>
                [
                    'persist'
                ]
        ]);
    }


    public function getSubscribedEvents(): array
    {
        return [Events::loadClassMetadata];
    }
}
