<?php

declare(strict_types=1);

namespace App\EventSubscriber\Portal\Email;

use App\Event\User\UserDeletedEvent;
use Symfony\Bridge\Twig\Mime\TemplatedEmail;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

final readonly class UserDeletedEmailEventSubscriber implements EventSubscriberInterface
{
    public function __construct(
        private TranslatorInterface $translator,
        private MailerInterface     $mailer
    )
    {
    }

    public static function getSubscribedEvents(): array
    {
        return [
            UserDeletedEvent::class => 'handle'
        ];
    }

    public function handle(UserDeletedEvent $userDeletedEvent): void
    {
        $templatedEmail = (new TemplatedEmail())
            ->to($userDeletedEvent->getUser()->getEmail())
            ->subject($this->translator->trans('Successful account deletion'))
            ->htmlTemplate('email/user_deleted.html.twig')
            ->context([
                'name' => $userDeletedEvent->getUser()->getFirstName()
            ]);
        $this->mailer->send($templatedEmail);
    }
}
