<?php

namespace App\EventSubscriber\Authentication;

use App\Exception\View\ManualConstraintViolationException;
use App\Service\View\ViewHandlerInterface;
use Gesdinet\JWTRefreshTokenBundle\Event\RefreshAuthenticationFailureEvent;
use Gesdinet\JWTRefreshTokenBundle\Security\Exception\InvalidTokenException;
use Gesdinet\JWTRefreshTokenBundle\Security\Exception\MissingTokenException;
use Gesdinet\JWTRefreshTokenBundle\Security\Exception\TokenNotFoundException;
use Lexik\Bundle\JWTAuthenticationBundle\Event\AuthenticationSuccessEvent;
use Lexik\Bundle\JWTAuthenticationBundle\Events;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class LoginResponseEventSubscriber implements EventSubscriberInterface
{
    private const REFRESH_EXCEPTIONS = [
        InvalidTokenException::class,
        MissingTokenException::class,
        TokenNotFoundException::class
    ];

    public function __construct(
        private readonly ViewHandlerInterface $viewHandler
    ) {}

    public static function getSubscribedEvents(): array
    {
        return [
            Events::AUTHENTICATION_SUCCESS => 'onAuthenticationSuccess',
            'gesdinet.refresh_token_failure' => 'onAuthenticationFailure'
        ];
    }

    public function onAuthenticationSuccess(AuthenticationSuccessEvent $event): void
    {
        $response = $this->viewHandler->handle([]);
        $data = json_decode($response->getContent() ?: '{}', true);

        $event->setData($data);
    }

    public function onAuthenticationFailure(RefreshAuthenticationFailureEvent $event): void
    {
        $path = 'username';
        $exception = $event->getException();

        if (in_array(get_class($exception), self::REFRESH_EXCEPTIONS)) {
            $path = 'token';
        }

        $message = $exception->getMessage() ?: $exception->getMessageKey();
        $response = $this->viewHandler->handle(new ManualConstraintViolationException($path, $message));

        $event->setResponse($response);
    }
}