<?php

namespace App\EventSubscriber\Authentication;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\Security\Http\Event\LogoutEvent;

class CookieClearerEventSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            LogoutEvent::class => 'onLogout'
        ];
    }

    public function onLogout(LogoutEvent $event): void
    {
        $request = $event->getRequest();
        $current_firewall_context = $request->attributes->get('_firewall_context');

        if ($current_firewall_context !== 'security.firewall.map.context.portal_api') {
            return;
        }

        $response = $event->getResponse();
        $response->headers->clearCookie('jwt_hp');
        $response->headers->clearCookie('jwt_s');
    }
}