<?php

namespace App\EventListener;

use Symfony\Bundle\SecurityBundle\Security;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\ControllerEvent;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\Translation\LocaleSwitcher;

final class LocaleSubscriber implements EventSubscriberInterface
{

    public function __construct(
        private readonly Security       $security,
        private readonly LocaleSwitcher $localeSwitcher
    )
    {
    }

    public static function getSubscribedEvents(): array
    {
        return [
            KernelEvents::CONTROLLER => [
                ['setLocale', 1]
            ]
        ];
    }

    public function setLocale(ControllerEvent $controllerEvent): void
    {
        $user = $this->security->getUser();

        if ($user === null) {
            return;
        }

        if (!method_exists($user, 'getLocale')) {
            return;
        }

        $requestLocale = $controllerEvent->getRequest()?->getLocale();
        $userLocale = $user->getLocale();

        if ($requestLocale === $userLocale) {
            return;
        }

        //$this->localeSwitcher->setLocale($userLocale);
    }
}
