<?php
declare(strict_types=1);

namespace App\EventListener;


use App\Entity\Education\Lesson\Lesson;
use App\Entity\Education\Lesson\LessonTranslation;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsEntityListener;
use Doctrine\ORM\Event\PostPersistEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Event\PrePersistEventArgs;
use Doctrine\ORM\Events;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\Uid\Uuid;

#[AsEntityListener(event: Events::postUpdate, method: 'postUpdate', entity: LessonTranslation::class)]
#[AsEntityListener(event: Events::prePersist, method: 'prePersist', entity: LessonTranslation::class)]
class LessonListener
{
    public function __construct(
        private readonly ParameterBagInterface $parameterBag,
    )
    {
    }

    public function postUpdate(LessonTranslation $lesson, PostUpdateEventArgs $args): void
    {

        $em = $args->getObjectManager();
        $uow = $em->getUnitOfWork();
        $changes = $uow->getEntityChangeSet($lesson);

        if (isset($changes['pdf']) && $changes['pdf'] != null) {
            if ($changes['pdf'][1]){
                //$lesson->setPreview($this->generatePreview($changes['pdf'][1]));
                //$em->flush();
            }


        }
    }

    public function prePersist(LessonTranslation $lesson, PrePersistEventArgs $args): void
    {
        $em = $args->getObjectManager();
        //$lesson->setPreview($this->generatePreview($lesson->getPdf()));

        //$em->persist($lesson);
        // $em->flush();

    }


    private function generatePreview(string $pdf): string
    {

        $fileName = Uuid::v4()->toRfc4122() . '.jpg';
        $pdfFilePath = $this->parameterBag->get('kernel.project_dir') . '/public' . urldecode($pdf);
        $tempJpegPath = $this->parameterBag->get('kernel.project_dir') . '/public/uploads/generated/' . $fileName;
        $command = "convert -density 150 -quality 100 {$pdfFilePath}[0] {$tempJpegPath}";

        try {
            exec($command);
        } catch (\Exception $e) {

        }

        return '/uploads/generated/' . $fileName;


    }

}
