<?php

declare(strict_types=1);

namespace App\Event\User;

use App\Entity\User\User;
use Symfony\Contracts\EventDispatcher\Event;
use SymfonyCasts\Bundle\ResetPassword\Model\ResetPasswordToken;

final class UserPasswordResetEvent extends Event
{
    public function __construct(
        private readonly User               $user,
        private readonly ResetPasswordToken $resetPasswordToken
    )
    {
    }

    public function getUser(): User
    {
        return $this->user;
    }

    public function getToken(): ResetPasswordToken
    {
        return $this->resetPasswordToken;
    }
}
