<?php

declare(strict_types=1);

namespace App\Entity\System\Webspace;

use App\Entity\Interfaces\MetableInterface;
use App\Entity\Shared\AbstractTranslatableEntity;
use App\Repository\System\Webspace\WebspaceRepository;
use App\Traits\Entity\Metable;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table('system_webspace')]
#[ORM\Entity(repositoryClass: WebspaceRepository::class)]
class Webspace extends AbstractTranslatableEntity implements MetableInterface
{
    use Metable;

    #[ORM\OneToMany(mappedBy: 'webspace', targetEntity: Config::class, cascade: ['persist'])]
    private Collection $configs;

    #[ORM\Column(length: 255)]
    #[Gedmo\Versioned]
    private ?string $code = null;

    public function __construct()
    {
        $this->configs = new ArrayCollection();
    }

    public function getConfigs(): Collection
    {
        return $this->configs;
    }

    public function addConfig(Config $config): self
    {
        if (!$this->configs->contains($config)) {
            $this->configs->add($config);
            $config->setWebspace($this);
        }

        return $this;
    }

    public function removeConfig(Config $config): self
    {
        if ($this->configs->removeElement($config) && $config->getWebspace() === $this) {
            $config->setWebspace(null);
        }

        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->code = $code;

        return $this;
    }
}
