<?php

declare(strict_types=1);

namespace App\Entity\System\Webspace;

use App\Entity\Shared\AbstractTranslationEntity;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Entity]
#[ORM\Table('system_webspace_config_translation')]
class ConfigTranslation extends AbstractTranslationEntity
{
    #[ORM\Column(length: 255)]
    #[Gedmo\Versioned]
    private ?string $value = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $file = null;

    public function getValue(): ?string
    {
        return $this->value;
    }

    public function setValue(string $value): self
    {
        $this->value = $value;

        return $this;
    }

    public function getFile(): ?string
    {
        return $this->file;
    }

    public function setFile(?string $file): self
    {
        $this->file = $file;

        return $this;
    }
}
