<?php

declare(strict_types=1);

namespace App\Entity\System\Page;

use App\Entity\Shared\AbstractTranslationEntity;
use App\Traits\Entity\ContentAware;
use App\Traits\Entity\Sluggable;
use App\Traits\Entity\Stateable;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
#[ORM\Table('system_page_translation')]
class PageTranslation extends AbstractTranslationEntity
{
    use Sluggable, Stateable, ContentAware;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $url = null;

    public function getUrl(): ?string
    {
        return $this->url;
    }

    public function setUrl(?string $url): static
    {
        $this->url = $url;

        return $this;
    }
}
