<?php

declare(strict_types=1);

namespace App\Entity\System\Page;

use App\Entity\Interfaces\BlockableInterface;
use App\Entity\Interfaces\MetableInterface;
use App\Entity\Shared\AbstractTranslatableEntity;
use App\Repository\System\Page\PageRepository;
use App\Traits\Entity\Blockable;
use App\Traits\Entity\Metable;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('system_page')]
#[ORM\Entity(repositoryClass: PageRepository::class)]
class Page extends AbstractTranslatableEntity implements MetableInterface, BlockableInterface
{
    use Metable, Blockable;
}
