<?php

declare(strict_types=1);

namespace App\Entity\System;

use App\Entity\Shared\AbstractEntity;
use App\Repository\System\MessageRepository;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table('system_message')]
#[ORM\Entity(repositoryClass: MessageRepository::class)]
class Message extends AbstractEntity
{
    #[ORM\Column(length: 255)]
    #[Gedmo\Versioned]
    private ?string $name = null;

    #[ORM\Column(length: 255)]
    #[Gedmo\Versioned]
    private ?string $email = null;

    #[ORM\Column(length: 500)]
    #[Gedmo\Versioned]
    private ?string $message = null;

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): static
    {
        $this->name = $name;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): static
    {
        $this->email = $email;

        return $this;
    }

    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function setMessage(string $message): static
    {
        $this->message = $message;

        return $this;
    }
}
