<?php

declare(strict_types=1);

namespace App\Entity\Magazine\Article;

use App\Entity\Shared\AbstractTranslationEntity;
use App\Traits\Entity\ContentAware;
use App\Traits\Entity\Publishable;
use App\Traits\Entity\Sluggable;
use App\Traits\Entity\Stateable;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Entity]
#[ORM\Table('magazine_article_translation')]
class ArticleTranslation extends AbstractTranslationEntity
{
    use Sluggable, Stateable, Publishable, ContentAware;

    #[ORM\Column(length: 255, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $intro = null;

    public function getIntro(): ?string
    {
        return $this->intro;
    }

    public function setIntro(?string $intro): self
    {
        $this->intro = $intro;

        return $this;
    }
}
