<?php

declare(strict_types=1);

namespace App\Entity\Interfaces;

use App\Entity\Common\Address;
use Doctrine\Common\Collections\Collection;

interface AddressableInterface
{
    public function getAddresses(): ?Collection;

    public function addAddress(Address $address): self;

    public function removeAddress(Address $address): self;
}
