<?php

declare(strict_types=1);

namespace App\Entity\Education\Lesson;

use App\Entity\Interfaces\BlockableInterface;
use App\Entity\Interfaces\MetableInterface;
use App\Entity\Interfaces\TagableInterface;
use App\Entity\Shared\AbstractTranslatableEntity;
use App\Repository\Education\Lesson\LessonRepository;
use App\Traits\Entity\Blockable;
use App\Traits\Entity\ImageAware;
use App\Traits\Entity\Metable;
use App\Traits\Entity\Tagable;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table('education_lesson')]
#[ORM\Entity(repositoryClass: LessonRepository::class)]
class Lesson extends AbstractTranslatableEntity implements MetableInterface, TagableInterface, BlockableInterface
{
    use Metable, Tagable, Blockable, ImageAware;

    #[ORM\ManyToOne(inversedBy: 'lessons')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Category $category = null;

    #[ORM\Column]
    private ?int $sort = 0;

    public function getCategory(): ?Category
    {
        return $this->category;
    }

    public function setCategory(?Category $category): static
    {
        $this->category = $category;

        return $this;
    }

    public function getSort(): ?int
    {
        return $this->sort;
    }

    public function setSort(int $sort): static
    {
        $this->sort = $sort;

        return $this;
    }
}
