<?php

declare(strict_types=1);

namespace App\Entity\Education\Lesson;

use App\Entity\Shared\AbstractTranslationEntity;
use App\Traits\Entity\ContentAware;
use App\Traits\Entity\HighlightedAware;
use App\Traits\Entity\Publishable;
use App\Traits\Entity\Sluggable;
use App\Traits\Entity\Stateable;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Entity]
#[ORM\Table('education_lesson_category_translation')]
class CategoryTranslation extends AbstractTranslationEntity
{
    use Sluggable, Stateable, HighlightedAware, Publishable, ContentAware;

    #[ORM\Column(length: 450, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $intro = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $displayTitle = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $link = null;

    public function getIntro(): ?string
    {
        return $this->intro;
    }

    public function setIntro(?string $intro): self
    {
        $this->intro = $intro;

        return $this;
    }

    public function getDisplayTitle(): ?string
    {
        return $this->displayTitle;
    }

    public function setDisplayTitle(?string $displayTitle): static
    {
        $this->displayTitle = $displayTitle;

        return $this;
    }

    public function getLink(): ?string
    {
        return $this->link;
    }

    public function setLink(?string $link): static
    {
        $this->link = $link;

        return $this;
    }
}
