<?php

declare(strict_types=1);

namespace App\Entity\Education\Exam;

use App\Entity\Interfaces\BlockableInterface;
use App\Entity\Interfaces\MetableInterface;
use App\Entity\Shared\AbstractTranslatableEntity;
use App\Repository\Education\ExamRepository;
use App\Traits\Entity\Blockable;
use App\Traits\Entity\ImageAware;
use App\Traits\Entity\Metable;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table('education_exam')]
#[ORM\Entity(repositoryClass: ExamRepository::class)]
class Exam extends AbstractTranslatableEntity implements MetableInterface, BlockableInterface
{
    use Metable, Blockable, ImageAware;
}
