<?php

declare(strict_types=1);

namespace App\Entity\Education\Benefit;

use App\Entity\Shared\AbstractTranslationEntity;
use App\Traits\Entity\HighlightedAware;
use App\Traits\Entity\Sluggable;
use App\Traits\Entity\Stateable;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Entity]
#[ORM\Table('education_benefit_translation')]
class BenefitTranslation extends AbstractTranslationEntity
{
    use Sluggable, Stateable, HighlightedAware;

    #[ORM\Column(length: 255, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $intro = null;

    public function getIntro(): ?string
    {
        return $this->intro;
    }

    public function setIntro(?string $intro): self
    {
        $this->intro = $intro;

        return $this;
    }
}
