<?php

declare(strict_types=1);

namespace App\Entity\Common\Support;

use App\Entity\Shared\AbstractTranslatableEntity;
use App\Repository\Common\TopicRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('system_faq_topic')]
#[ORM\Entity(repositoryClass: TopicRepository::class)]
class Topic extends AbstractTranslatableEntity
{
    #[ORM\OneToMany(mappedBy: 'topic', targetEntity: Faq::class)]
    private Collection $faqs;

    public function __construct()
    {
        $this->faqs = new ArrayCollection();
    }

    /**
     * @return Collection<int, Faq>
     */
    public function getFaqs(): Collection
    {
        return $this->faqs;
    }

    public function addFaq(Faq $faq): static
    {
        if (!$this->faqs->contains($faq)) {
            $this->faqs->add($faq);
            $faq->setTopic($this);
        }

        return $this;
    }

    public function removeFaq(Faq $faq): static
    {
        if ($this->faqs->removeElement($faq)) {
            // set the owning side to null (unless already changed)
            if ($faq->getTopic() === $this) {
                $faq->setTopic(null);
            }
        }

        return $this;
    }
}
