<?php

declare(strict_types=1);

namespace App\Entity\Common\Support;

use App\Entity\Shared\AbstractTranslationEntity;
use App\Traits\Entity\ContentAware;
use App\Traits\Entity\Stateable;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Entity]
#[ORM\Table('system_faq_translation')]
class FaqTranslation extends AbstractTranslationEntity
{
    use Stateable, ContentAware;

    #[ORM\Column(length: 255)]
    #[Gedmo\Versioned]
    private ?string $question = null;

    public function getQuestion(): ?string
    {
        return $this->question;
    }

    public function setQuestion(string $question): self
    {
        $this->question = $question;

        return $this;
    }
}
