<?php

declare(strict_types=1);

namespace App\Entity\Common\Support;

use App\Entity\Shared\AbstractTranslatableEntity;
use App\Repository\Common\FaqRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('system_faq')]
#[ORM\Entity(repositoryClass: FaqRepository::class)]
class Faq extends AbstractTranslatableEntity
{
    #[ORM\ManyToOne(inversedBy: 'faqs')]
    #[ORM\JoinColumn(nullable: false)]
    private ?Topic $topic = null;

    public function getTopic(): ?Topic
    {
        return $this->topic;
    }

    public function setTopic(?Topic $topic): static
    {
        $this->topic = $topic;

        return $this;
    }
}
