<?php

declare(strict_types=1);

namespace App\Entity\Common\Layout;

use App\Entity\Shared\AbstractTranslationEntity;
use App\Traits\Entity\ContentAware;
use App\Traits\Entity\ImageAware;
use App\Traits\Entity\Sluggable;
use App\Traits\Entity\Stateable;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Entity]
#[ORM\Table('common_block_translation')]
class BlockTranslation extends AbstractTranslationEntity
{
    use Sluggable, Stateable, ImageAware, ContentAware;

    #[ORM\Column(length: 450, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $lead = null;

    #[ORM\Column(length: 255, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $url = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $subtitle = null;

    #[ORM\Column(type: 'simple_array', nullable: true)]
    private $gallery;

    public function getLead(): ?string
    {
        return $this->lead;
    }

    public function setLead(?string $lead): self
    {
        $this->lead = $lead;

        return $this;
    }

    public function getUrl(): ?string
    {
        return $this->url;
    }

    public function setUrl(?string $url): self
    {
        $this->url = $url;

        return $this;
    }

    public function getSubtitle(): ?string
    {
        return $this->subtitle;
    }

    public function setSubtitle(?string $subtitle): static
    {
        $this->subtitle = $subtitle;

        return $this;
    }

    public function getGallery(): ?array
    {
        return $this->gallery;
    }

    public function setGallery(?array $gallery): self
    {
        $this->gallery = $gallery;

        return $this;
    }
}
