<?php

declare(strict_types=1);

namespace App\Entity\Common\Layout;

use App\Entity\Shared\AbstractTranslatableEntity;
use App\Repository\Common\Layout\BlockRepository;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table('common_block')]
#[ORM\Entity(repositoryClass: BlockRepository::class)]
class Block extends AbstractTranslatableEntity
{
    #[ORM\Column(length: 100)]
    #[Gedmo\Versioned]
    private ?string $template = null;

    #[ORM\Column(nullable: true)]
    #[Gedmo\Versioned]
    private ?int $position = null;

    public function getTemplate(): ?string
    {
        return $this->template;
    }

    public function setTemplate(string $template): self
    {
        $this->template = $template;

        return $this;
    }

    public function getPosition(): ?int
    {
        return $this->position;
    }

    public function setPosition(?int $position): self
    {
        $this->position = $position;

        return $this;
    }
}
