<?php

declare(strict_types=1);

namespace App\Entity\Common\Category;

use App\Entity\Interfaces\MetableInterface;
use App\Entity\Interfaces\NestedableInterface;
use App\Entity\Shared\AbstractTranslatableEntity;
use App\Repository\Common\CategoryRepository;
use App\Traits\Entity\Metable;
use App\Traits\Entity\Nestedable;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table('system_category')]
#[ORM\Entity(repositoryClass: CategoryRepository::class)]
#[Gedmo\Tree(type: 'nested')]
class Category extends AbstractTranslatableEntity implements MetableInterface, NestedableInterface
{
    use Metable, Nestedable;
}
