<?php

declare(strict_types=1);

namespace App\DTO\PublicAPI\User\Input;

use Symfony\Component\Validator\Constraints as Assert;

final class ResendVerification
{
    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string'),
        new Assert\Email(),
        new Assert\Length(min: 3, max: 255),
    ])]
    public $email;
}
