<?php

declare(strict_types=1);

namespace App\DTO\PublicAPI\User\Input;

use App\DTO\Shared\Input\RecaptchaTrait;
use App\Validator\Constraints\EmailNotRegistered;
use App\Validator\Constraints\Password;
use Symfony\Component\Validator\Constraints as Assert;

final class FormRegistration
{
    use RecaptchaTrait;

    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string'),
        new Assert\Length(min: 3, max: 255),
    ])]
    public $firstName;

    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string'),
        new Assert\Length(min: 3, max: 255),
    ])]
    public $lastName;

    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string'),
        new Assert\Length(min: 3, max: 255),
        new Assert\Email(),
        new EmailNotRegistered()
    ])]
    public $email;

    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string'),
        new Password(),
        new Assert\Length(min: 8, max: 255)
    ])]
    public $password;

    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('boolean'),
        new Assert\IsTrue()
    ])]
    public $agreePrivacyPolicy;
}
