<?php

declare(strict_types=1);

namespace App\DTO\PublicAPI\User\Input;

use App\Enum\User\UserDeletionReason;
use Symfony\Component\Validator\Constraints as Assert;

final class DeleteUser
{
    #[Assert\Sequentially([
        new Assert\NotBlank(),
    ])]
    public ?UserDeletionReason $reason = null;

    #[Assert\When(
        expression: 'this.reason !== null && this.reason.value === "other"',
        constraints: [
            new Assert\Sequentially([
                new Assert\NotBlank(),
                new Assert\Type('string'),
                new Assert\Length(min: 3, max: 255)
            ])
        ]
    )]
    public $otherReason;
}
