<?php

declare(strict_types=1);

namespace App\DTO\PublicAPI\Shared\Input;

use App\Service\Filter\Model\FilterInterface;
use Symfony\Component\Validator\Constraints as Assert;

final class TagFilter implements FilterInterface
{
    #[Assert\Sequentially([
        new Assert\Type('string'),
        new Assert\Length(min: 0, max: 255)
    ])]
    public $keyword;

    #[Assert\Sequentially([
        new Assert\Type('boolean')
    ])]
    public $isHighlighted;
}
