<?php

declare(strict_types=1);

namespace App\DTO\PublicAPI\Page;

use App\DTO\PublicAPI\Shared\Output\Meta;
use Symfony\Component\Uid\Uuid;

final readonly class PageDetails
{
    public function __construct(
        public ?Uuid   $id,
        public ?string $title,
        public string  $slug,
        public ?Meta   $meta,
        public ?array  $content,
    )
    {
    }
}
