<?php

declare(strict_types=1);

namespace App\Controller\Portal\System;

use App\DTO\PublicAPI\Shared\Input\TagFilter;
use App\Repository\Common\TagRepository;
use App\Service\Pagination\Context\PaginationContextInterface;
use App\Service\View\Context\ViewContext;
use App\Service\View\ViewHandlerInterface;
use App\Transformer\DTO\Shared\TagTransformer;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/system/tags', name: 'system_tag_')]
final class TagController extends AbstractController
{
    public function __construct(
        private readonly TagRepository                      $tagRepository,
        private readonly TagTransformer                     $tagTransformer,
        private readonly ViewHandlerInterface               $viewHandler,
        private readonly RequestStack                       $requestStack
    )
    {
    }

    #[Route(path: '', name: 'list', methods: ['GET'])]
    public function list(PaginationContextInterface $paginationContext, TagFilter $filter): Response
    {
        $tags = $this->tagRepository->findPublicTags(
            $this->requestStack->getCurrentRequest()->getLocale(),
            $paginationContext,
            $filter,
        );

        $tags = array_map($this->tagTransformer, $tags);

        return $this->viewHandler->handle($tags, new ViewContext(extra: [
            'pagination' => $paginationContext
        ]));
    }


}
