<?php

declare(strict_types=1);

namespace App\Controller\Portal\Profile;

use App\Entity\User\User;
use App\Service\View\ViewHandlerInterface;
use App\Transformer\DTO\User\UserDetailsTransformer;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Bundle\SecurityBundle\Security;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\UnauthorizedHttpException;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/profile', name: 'profile_view', methods: ['GET'])]
final class ViewController extends AbstractController
{
    public function __construct(
        private readonly Security               $security,
        private readonly UserDetailsTransformer $userDetailsTransformer,
        private readonly ViewHandlerInterface   $viewHandler
    )
    {
    }

    public function __invoke(): Response
    {
        $user = $this->security->getUser();

        if (!$user instanceof User) {
            throw new UnauthorizedHttpException('');
        }

        $transform = $this->userDetailsTransformer;
        $userDetails = $transform($user);

        return $this->viewHandler->handle($userDetails);
    }
}
