<?php

declare(strict_types=1);

namespace App\Controller\Portal\Profile;

use App\Command\Portal\User\DeleteUser as DeleteUserCommand;
use App\DTO\PublicAPI\User\Input\DeleteUser;
use App\Entity\User\User;
use App\Service\Authentication\Cookie\AuthenticationCookieClearerInterface;
use App\Service\Command\CommandBusInterface;
use App\Service\View\ViewHandlerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Bundle\SecurityBundle\Security;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/profile', name: 'profile_delete', methods: ['DELETE'])]
final class DeleteController extends AbstractController
{
    public function __construct(
        private readonly Security                             $security,
        private readonly CommandBusInterface                  $commandBus,
        private readonly AuthenticationCookieClearerInterface $authenticationCookieClearer,
        private readonly ViewHandlerInterface                 $viewHandler
    )
    {
    }

    public function __invoke(#[MapRequestPayload] DeleteUser $deleteUser): Response
    {
        /** @var User $user */
        $user = $this->security->getUser();
        $this->commandBus->handle(new DeleteUserCommand(
            $user->getId()->toRfc4122(),
            $deleteUser->reason,
            $deleteUser->otherReason
        ));

        $response = $this->viewHandler->handle([]);
        $this->authenticationCookieClearer->clear($response);

        return $response;
    }
}
